/*
 * Copyright (c) 2015 Adobe Systems.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50 */
/*global exports */
"use strict";

// Protocol details taken from http://cgit.sukimashita.com/libusbmuxd.git/tree/include/usbmuxd-proto.h

/**
 * @constant {string} unix domain socket path to connect to usbmuxd. Used on OSX
 */
var DOMAIN_SOCKET_PATH = "/var/run/usbmuxd";

/**
 * @constant {number} ip port to connect to usbmuxd. Used on Windows
 */
var USBMUXD_SOCKET_PORT = 27015;

// USBMUX Protocol versions

/**
 * @constant {number} specifies the binary protocol
 */
var USBMUX_PROTOCOL_VERSION_BINARY = 0;

/**
 * @constant {number} specifies the plist protocol
 */
var USBMUX_PROTOCOL_VERSION_PLIST = 1;

// USBMUXD result communication status codes
/**
 * @constant {number} wrong protocol version
 */
var RESULT_BADVERSION = 6;

/**
 * @constant {number} lockscreen is visible or app on mobile device not runnning
 */
var RESULT_LOCKSCREEN_OR_APP_NOT_RUNNING = 3;

// API
exports.DOMAIN_SOCKET_PATH                   = DOMAIN_SOCKET_PATH;
exports.USBMUXD_SOCKET_PORT                  = USBMUXD_SOCKET_PORT;
exports.USBMUX_PROTOCOL_VERSION_BINARY       = USBMUX_PROTOCOL_VERSION_BINARY;
exports.USBMUX_PROTOCOL_VERSION_PLIST        = USBMUX_PROTOCOL_VERSION_PLIST;
exports.RESULT_BADVERSION                    = RESULT_BADVERSION;
exports.RESULT_LOCKSCREEN_OR_APP_NOT_RUNNING = RESULT_LOCKSCREEN_OR_APP_NOT_RUNNING;
